<?php
    /**
    *
    * copyright (c) 2013-2024 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    $geecomDb = $GLOBALS["geecomDb"];
    
    $ordine = $geecomDb->leggiSingolaRiga("geecEc_ordini",filter_input(INPUT_GET,"idOrdine",FILTER_SANITIZE_NUMBER_INT));
?>
<body>
    <?php 
        echo $inclusioni["inizioBody"];
    ?>
    <div class="wrapper">
	<?php 
	    include "template/include/menuPrincipale.php";
	?>    
        <!-- Contenuto principale  -->
        <div id="content" class="p-0 extramargin d-flex flex-column">
            <div class="page-wrapper">
		<?php 
		    include "template/include/barraSuperiore.php";
		?>
                <main class="py-4">
		        <?php
		            if($ordine["idCliente"]==$_SESSION["geecomUser_id"]) { // l'ordine viene mostrato solo se è dell'utente che lo sta richiedendo
		    	?>
				<div class="container" >
		                    <div class="">
		                    	<?php
			                    	if($ordine["stato"]=="spedito") {
							$classeBadge = "badge-success";
						}
						else if($ordine["stato"]=="annullato") {
							$classeBadge = "badge-danger";
						}
						else {
							$classeBadge = "badge-info";
						}
		                    	?>
					<h2 class="d-inline-block page-title">Dettagli dell'ordine n.  <?php echo $ordine["id"]."<span class=\"badge $classeBadge ml-3\">{$ordine["stato"]}</span>"; ?></h2>
		                        <a class="d-inline-block float-right btn btn-outline-primary" href="index.php?alias=ordini"><i class="fas fa-arrow-left mr-2"></i>Torna indietro</a>
		                    </div>
		                    
					<div class="card">
					  	<div class="card-body">
							<div class="row">
						      
		                                            <!-- prima colonna -->
		                                            <div id="colonnaPrincipale" class="col-md-5">
		                                            <?php 
								  
								   $dataRegistrazione = date("d/m/Y",strtotime($ordine["dataOrdine"]));
							      ?>
							      	   <p><strong>Data ordine:</strong> <?php echo $dataRegistrazione ?></p>

							      	   <p><strong>Metodo di pagamento:</strong> <?php echo $ordine["tipoPagamento"] ?></p>
							      	   
	   						      	   <p><strong>Tipo di spedizione:</strong> <?php echo $ordine["tipoSpedizione"] ?></p>
								 <?php
									if($ordine["codiceTracciamento"]!="") {
								 ?>							
										<p><strong>Codice tracciamento:</strong> <?php echo $ordine["codiceTracciamento"] ?></p>
								 <?php
									}
								 ?>
								 
								 <p><strong>Destinatario:</strong> <?php echo $ordine["destinatario"] ?></p>
								 
								 <p><strong>Indirizzo di spedizione:</strong> <?php echo "{$ordine["indirizzoSpedizione"]}, {$ordine["citta"]}, {$ordine["capSpedizione"]}" ?></p>

								 <p><strong>Importo ordine:</strong> <?php echo $ordine["importoTotaleOrdine"] ?> €</p>

								 <p><strong>Tipo ricevuta:</strong> <?php echo $ordine["tipoRicevuta"] ?></p>
							      </div>
							      <!-- /prima colonna --> 

							      <!-- seconda colonna --> 
							      <div id="colonnaSecondaria" class="col-md-7">
								 <h4 class="text-primary">Prodotti ordinati</h4>

								 <!-- tabella -->
								 <div class="table-responsive">
									<table class="table table-hover table-condensed">
								     <thead>
									<tr>
									  <th>Oggetto</th>
									  <th>Quantità</th>
									  <th>Costo unitario</th>
									</tr>
								     </thead>
								     <tbody>

								   <?php 
									$queryProdottiOrdinati = "SELECT * FROM geecEc_prodottiOrdinati AS prodottiOrdinati JOIN geecEc_prodotti AS prodotti on  prodottiOrdinati.idProdotto=prodotti.id WHERE idCarrello={$ordine["idCarrello"]}";

									$result = $geecomDb->eseguiQueryLettura($queryProdottiOrdinati);
									while($prodottoOrdinato=$result->fetch_assoc()) {
									    if($prodottoOrdinato["idOpzione"]>0) {
										$queryOpzioneOrdinata = "SELECT * FROM geecEc_opzioniAcquisto WHERE id={$prodottoOrdinato["idOpzione"]}";
										if(!$risOpzione = $geecomDb->eseguiQueryLettura($queryOpzioneOrdinata)) {
										    echo "Errore nell'esecuzione della query: ".$geecomDb->error;
										    exit();
										}
										$opzioneOrdinata = $risOpzione->fetch_assoc();
										echo"<tr>
										<td><a href=../prodotto.php?id={$prodottoOrdinato["idProdotto"]} target=\"_blank\">{$prodottoOrdinato["nomeProdotto"]}  </a> con opzione <a href=creaOpzione.php?id={$opzioneOrdinata["id"]}>{$opzioneOrdinata["nome"]} {$opzioneOrdinata["attributo"]}</a></td>
										<td>{$prodottoOrdinato["quantita"]}</td>
										<td>{$prodottoOrdinato["prezzoUnitario"]} + {$prodottoOrdinato["prezzoUnitarioOpzione"]}</td>
									      </tr>";
									     }
									     else {
										    echo"<tr>
										<td><a href=../prodotto.php?id={$prodottoOrdinato["idProdotto"]} target=\"_blank\" >{$prodottoOrdinato["nomeProdotto"]} </a></td>
										<td>{$prodottoOrdinato["quantita"]}</td>
										<td>{$prodottoOrdinato["prezzoUnitario"]}</td>
									      </tr>";
									     }
									}
								    ?>

								     </tbody>
								   </table>
								 </div>
								 <!-- /tabella -->

							  </div>
							 <!-- /seconda colonna -->
						  	</div>
						</div>
				     	</div>
				</div>

				<?php

				    $queryComponentiDaMostrare = "SELECT c.id, cm.nome, c.testo, c.posizione FROM geecAd_composizionePagine AS c JOIN geecAd_componenti AS cm ON c.idComponente=cm.id WHERE idPagina={$pagina["id"]} ORDER BY c.posizione ASC";
				    $risComponenti = $geecomDb->eseguiQueryLettura($queryComponentiDaMostrare);
				    while($componente = $risComponenti->fetch_assoc()) { 
					 if($componente["nome"]=="Testo") {
					     stampaTesto($componente);
					 }
					 if($componente["nome"]=="Codice html") {
					     stampaCodiceHtml($componente);
					 }
					 if($componente["nome"]=="Immagine a tutto schermo") {
					     stampaImmagine($componente);
					 }
					 if($componente["nome"]=="Includi codice") {
					     includiCodice($componente);
					 }
				    }
		            }
		            else { //  altrimenti verrà mostrato un messaggio di errore
		            	?>
		            	<div class="alert alert-danger">
		            		Non disponi dei permessi per visualizzare quest'ordine
		            	</div>
		            	<?php
		            }
			?>
		 </main>
            </div>
	    <?php
		include "template/include/footer.php";
	    ?>
        </div>
    </div>
    <?php
        if($impostazioni["accessoFacebook"]=="si") {
            include "include/facebookSdk.php";
        }

        include"include/includeJsBase.php"; 
        include"template/include/includeJsTemplate.php"; 
        
        echo $inclusioni["fineBody"];
    ?>
</body>
